''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Document Browser                                                '
'Allows optionally                                               '
'1. Look through the user-defined directory and open needed      '
'   ChemSketch's files                                           '
'2. Search files from the user-defined directory according to    '
'   user-defined string                                          '
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Function Main As String

Dim Form As Object
Dim mask, dir, UserStr, Action, fname, Temp, Message As String
Dim n As Boolean, i As Integer

'Form executing
 dir=JustPathName(GetProgPathName)
 UserStr=""
 Action=""
 fname="" 

 Form=ReadForm("Browser.frm")
 Do
    Form.SetStrValue("Dir", dir)  
    Form.SetStrValue("UserStr", UserStr)
    Form.SetStrValue("Action", Action)
    Form.SetStrValue("FileName", fname) 
    If Form.ExecForm Then
         dir=Form.GetStrValue("Dir")
         UserStr=Form.GetStrValue("UserStr")
         Action=Form.GetStrValue("Action")
         fname=Form.GetStrValue("FileName")
    Else
         Main="Cancelled"
         Exit Function
    End If

'Entered values processing
    If Right(dir,1) <> "\" Then dir = dir + "\"
    If fname = "" Then 
        fname = "*.sk2"
    Else
        fname = RemoveExtension(fname) + ".sk2"  'force ChemSketch extension
    End If
    mask = dir + fname
    n = FindFirst(mask, Temp)
    If n = True Then
        Message = "Search is complete."+Chr(13)+"Do you want to perform another search?"
        If Action = "Look through the directory" Then
             Call LookThrough(fname, mask, dir)
        Else
             If UserStr = "" Then
                 MessageBox("Query String is empty. Please fill it.", "Document Browser", MBB_OK or MBI_INFORMATION)
                 Message = ""
             Else
                 Call SearchUserString(fname, mask, dir, UserStr)
             End If
        End If     
    Else
        Message = "No files were found." + Chr(13)+ "Do you want to check path and mask or search another directory?"
    End If
    If Message <> "" Then
      i = MessageBox(Message,"Document Browser", MBB_YESNO or MBI_QUESTION)   
    Else
      i = MBR_OK
    End If
 Loop While i <> MBR_NO
 Main="Completed"

End Function

 
Sub LookThrough(fname As String, mask As String, dir As String)
Dim Point As String, n As boolean, i,NDoc As Integer
Dim Form, CurDoc, FirstPage As Object
Dim a,FileFound As String
Dim Yes, No, Cancel As String
 Yes   ="Yes    to find more files" + Chr(13)
 No    ="No     to close and find next" + Chr(13)
 Cancel="Cancel to stop searching"
 FileFound="Query file was found."+Chr(13)+Chr(13)+Yes+No+Cancel
 n = FindFirst(mask, a)
 Do
    NDoc=Documents.Count
    If NDoc=10 Then Stop "You have already 10 documents open."
    CurDoc=Documents.AddFromFile(dir+a, FT_SKETCH)
    FirstPage=CurDoc.Item(1)
    CurDoc.SetActivePage(FirstPage)
    i=MessageBox(FileFound, "Document Browser",MBB_YESNOCANCEL or MBI_QUESTION)  
    Select Case i 
        Case MBR_NO 
            Kill(CurDoc)
        Case MBR_CANCEL
            Exit Sub 
    End Select  
    n = FindNext(a)
 Loop While n = True
End Sub

 
Sub SearchUserString(fname As String,mask As String, dir As String, UserStr As String)
Dim  n As boolean, i,NDoc,l,m,x,y As Integer
Dim Point, FoundMsg, NotFoundMsg, a, MyStr, MyUStr, UserUStr, ext As String
Dim Form, CurDoc, MyPage, TB As Object
 FoundMsg = "Query String was found."+Chr(13)+Chr(13)+"Do you want to find next?"
 NotFoundMsg = "All the documents were searched."+Chr(13)+"Query String was not found."
 x=0
 y=0
 UserUStr=UCase(UserStr)
 n = FindFirst(mask, a)
 Do  
      NDoc=Documents.Count
      If NDoc=10 Then Stop "You have already 10 documents open."
      CurDoc=Documents.AddFromFile(dir+a, FT_SKETCH)
      For each MyPage in CurDoc
           For each TB in MyPage.Textboxes
               MyStr=TB.GetContent
               MyUStr=UCase(MyStr)
               x=InStr(1,MyUStr, UserUStr)
               If x<>0 Then 
                   y=1
                   CurDoc.SetActivePage(MyPage)
                   l=MessageBox(FoundMsg, "Document Browser", MBB_YESNO+MBI_QUESTION)   
                   If l=MBR_NO Then Exit Sub
               Else
               End If
           Next TB    
      Next MyPage          
      Kill(CurDoc)  
      n = FindNext(a)
 Loop While n = True
 If x=0 Then MessageBox(NotFoundMsg, "Document Browser", MBB_OK)

End Sub


' Remove extension from the given filename
function RemoveExtension(ByVal FileName As String) As String
Dim PointPos, BackslashPos As Integer

  PointPos = RInStr(FileName, ".")
  If PointPos = 0 Then
    RemoveExtension = FileName
  Else
    BackslashPos = RInStr(FileName, "\")
    If BackslashPos > PointPos Then
      RemoveExtension = FileName
    Else
      RemoveExtension = Left(FileName, PointPos - 1)
    End If
  End If
End Function

' Returns the rightmost position of substring SubStr inside string S, 0 if S doesn't contain SubStr
Function RInStr(ByVal S As String, ByVal SubStr As String) As Integer
Dim I As Integer

  I = 0
  Do
    RInStr = I
    I = InStr(I + 1, S, SubStr)
  Loop While I <> 0

End Function
